VERSION 5.00
Begin VB.UserControl ucExample 
   ClientHeight    =   3600
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   4800
   ScaleHeight     =   3600
   ScaleWidth      =   4800
End
Attribute VB_Name = "ucExample"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'ucExample
'  This user control demos how to use clsControlWatcher and
'  clsEventWatcher to receive selected events from the controls
'  living in the parent of a usercontrol.

Option Explicit

' Reference to the main Event Watcher
Private WithEvents m_EventWatcher As clsEventWatcher
Attribute m_EventWatcher.VB_VarHelpID = -1

Private Sub m_EventWatcher_ClickOccured(InControl As Control)
    'A click occured in one of the sibling controls
    
    Debug.Print Timer, "Click occured in " & InControl.Name
    
End Sub

Private Sub m_EventWatcher_KeyPressOccured(InControl As Control, _
        KeyAscii As Integer)
    'A key press occured in one of the sibling controls.
    'Note: since KeyAscii is passed byref, any changes to it will
    '      effect the foreign control
    
    Debug.Print Timer, "Key Press (" & Format(KeyAscii) & ") occured in " & _
                "" & InControl.Name
    
End Sub

Public Sub InitControls()
    'Public initialize sub.  Has to be a seperate sub, since inside of
    '   the _Initialize event, we can't acces the parent's state.
    
    'Bail out if we're in the IDE
    If Not Ambient.UserMode Then
        Exit Sub
    End If
    
    'Create the event watcher object
    Set m_EventWatcher = New clsEventWatcher
    
    Dim ctrl As Control
    Dim obj As clsControlWatcher
    
    'Loop through every control in the parent.  If it's a control type
    'we understand, make a control watcher, and point it to our main
    'event watcher object
    For Each ctrl In Parent.Controls
        If TypeOf ctrl Is TextBox Then
            Set obj = New clsControlWatcher
            Set obj.m_EventWatcher = m_EventWatcher
            Set obj.m_TextBox = ctrl
        ElseIf TypeOf ctrl Is ListBox Then
            Set obj = New clsControlWatcher
            Set obj.m_EventWatcher = m_EventWatcher
            Set obj.m_ListBox = ctrl
        End If
    Next
    
End Sub

