VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsControlWatcher"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'clsControlWatcher
'  This class simply watches for events from controls, and upon seeing
'  them passes the events on to a EventWatcher object

Option Explicit

Public WithEvents m_TextBox As TextBox
Attribute m_TextBox.VB_VarHelpID = -1
Public WithEvents m_ListBox As ListBox
Attribute m_ListBox.VB_VarHelpID = -1

Public WithEvents m_EventWatcher As clsEventWatcher
Attribute m_EventWatcher.VB_VarHelpID = -1

'Keep a reference to ourself, so we can stay alive, even if no
' one else is paying attention
Private m_SelfRef As clsControlWatcher

Private Sub Class_Initialize()
    
    'Make the self reference, can't be destroyed now,
    ' until this reference is released.
    Set m_SelfRef = Me
    
End Sub

Private Sub m_EventWatcher_Unload()
    'This event is triggered when EventWatcher unloads, so go ahead and
    ' release our self reference, so VB will destroy this object
    ' (since, without a EventWatcher, this class is pointless)
    
    Set m_SelfRef = Nothing
    
End Sub

'The remain subs just pass along events to the EventWatcher

Private Sub m_ListBox_Click()
    
    m_EventWatcher.RaiseClick m_ListBox
    
End Sub

Private Sub m_ListBox_KeyPress(KeyAscii As Integer)
    
    m_EventWatcher.RaiseKeyPress m_ListBox, KeyAscii
    
End Sub

Private Sub m_TextBox_Click()
    
    m_EventWatcher.RaiseClick m_TextBox
    
End Sub

Private Sub m_TextBox_KeyPress(KeyAscii As Integer)
    
    m_EventWatcher.RaiseKeyPress m_TextBox, KeyAscii
    
End Sub

